"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallPrecheck = stepInstallPrecheck;
var _ensure_fleet_global_es_assets = require("../../../../setup/ensure_fleet_global_es_assets");
var _ = require("../../../..");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallPrecheck() {
  await ensureFleetGlobalAssets();
}
async function ensureFleetGlobalAssets() {
  await (0, _utils.withPackageSpan)('Ensure Fleet Global Assets', () => (0, _ensure_fleet_global_es_assets.ensureFleetGlobalEsAssets)({
    logger: _.appContextService.getLogger(),
    esClient: _.appContextService.getInternalUserESClient(),
    soClient: _.appContextService.getInternalUserSOClient()
  }, {
    reinstallPackages: false
  }));
}