"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDefaultSettings = buildDefaultSettings;
var _app_context = require("../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildDefaultSettings({
  ilmPolicy,
  type
}) {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const isILMPolicyDisabled = (_appContextService$ge = (_appContextService$ge2 = _app_context.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  return {
    index: {
      ...(isILMPolicyDisabled ? {} : {
        // ILM Policy must be added here, for now point to the default global ILM policy name
        lifecycle: {
          name: ilmPolicy ? ilmPolicy : type
        }
      })
    }
  };
}