"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.backfillPackagePolicySupportsAgentless = backfillPackagePolicySupportsAgentless;
var _pMap = _interopRequireDefault(require("p-map"));
var _constants = require("../constants");
var _agent_policy = require("./agent_policy");
var _ = require(".");
var _package_policy = require("./package_policy");
var _package_policies = require("./package_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function backfillPackagePolicySupportsAgentless(esClient) {
  const apSavedObjectType = await (0, _agent_policy.getAgentPolicySavedObjectType)();
  const internalSoClientWithoutSpaceExtension = _.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const findRes = await internalSoClientWithoutSpaceExtension.find({
    type: apSavedObjectType,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    filter: `${apSavedObjectType}.attributes.supports_agentless:true`,
    fields: [`id`],
    namespaces: ['*']
  });
  const agentPolicyIds = findRes.saved_objects.map(so => so.id);
  if (agentPolicyIds.length === 0) {
    return;
  }
  const savedObjectType = await (0, _package_policy.getPackagePolicySavedObjectType)();
  const packagePoliciesToUpdate = (await _.appContextService.getInternalUserSOClientWithoutSpaceExtension().find({
    type: savedObjectType,
    fields: ['name', 'policy_ids', 'supports_agentless', 'enabled', 'policy_ids', 'inputs', 'package'],
    filter: `(NOT ${savedObjectType}.attributes.supports_agentless:true) AND ${savedObjectType}.attributes.policy_ids:(${agentPolicyIds.join(' OR ')})`,
    perPage: _constants.SO_SEARCH_LIMIT,
    namespaces: ['*']
  })).saved_objects.map(so => (0, _package_policies.mapPackagePolicySavedObjectToPackagePolicy)(so, so.namespaces));
  _.appContextService.getLogger().debug(`Backfilling supports_agentless on package policies: ${packagePoliciesToUpdate.map(policy => policy.id)}`);
  if (packagePoliciesToUpdate.length > 0) {
    const getPackagePolicyUpdate = packagePolicy => ({
      name: packagePolicy.name,
      enabled: packagePolicy.enabled,
      policy_ids: packagePolicy.policy_ids,
      inputs: packagePolicy.inputs,
      supports_agentless: true
    });
    await (0, _pMap.default)(packagePoliciesToUpdate, packagePolicy => {
      var _packagePolicy$spaceI;
      const soClient = _.appContextService.getInternalUserSOClientForSpaceId((_packagePolicy$spaceI = packagePolicy.spaceIds) === null || _packagePolicy$spaceI === void 0 ? void 0 : _packagePolicy$spaceI[0]);
      return _package_policy.packagePolicyService.update(soClient, esClient, packagePolicy.id, getPackagePolicyUpdate(packagePolicy));
    }, {
      concurrency: 50
    });
  }
}