"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStartMock = void 0;
var _ui_extensions = require("../services/ui_extensions");
var _plugin_configuration = require("./plugin_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createStartMock = (extensionsStorage = {}) => {
  return {
    isInitialized: jest.fn().mockResolvedValue(true),
    registerExtension: (0, _ui_extensions.createExtensionRegistrationCallback)(extensionsStorage),
    authz: {
      fleet: {
        all: true,
        setup: true,
        readEnrollmentTokens: true,
        readAgentPolicies: true,
        allAgentPolicies: true,
        allAgents: true,
        allSettings: true,
        readAgents: true,
        readSettings: true,
        addAgents: true,
        addFleetServers: true
      },
      integrations: {
        readPackageInfo: true,
        readInstalledPackages: true,
        installPackages: true,
        upgradePackages: true,
        uploadPackages: true,
        removePackages: true,
        readPackageSettings: true,
        writePackageSettings: true,
        readIntegrationPolicies: true,
        writeIntegrationPolicies: true
      }
    },
    config: (0, _plugin_configuration.createConfigurationMock)(),
    hooks: {
      epm: {
        getBulkAssets: jest.fn()
      }
    }
  };
};
exports.createStartMock = createStartMock;