"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGetOnePackagePolicy = exports.sendDeletePackagePolicy = exports.sendCreatePackagePolicy = void 0;
exports.sendGetOrphanedIntegrationPolicies = sendGetOrphanedIntegrationPolicies;
exports.sendUpdatePackagePolicy = exports.sendGetPackagePolicies = void 0;
exports.sendUpgradePackagePolicy = sendUpgradePackagePolicy;
exports.sendUpgradePackagePolicyDryRun = sendUpgradePackagePolicyDryRun;
exports.useGetOnePackagePolicyQuery = exports.useGetOnePackagePolicy = void 0;
exports.useGetPackagePolicies = useGetPackagePolicies;
exports.useGetPackagePoliciesQuery = useGetPackagePoliciesQuery;
exports.useUpgradePackagePoliciesMutation = useUpgradePackagePoliciesMutation;
exports.useUpgradePackagePolicyDryRunQuery = useUpgradePackagePolicyDryRunQuery;
var _reactQuery = require("@kbn/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendCreatePackagePolicy = body => {
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getCreatePath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(body)
  });
};
exports.sendCreatePackagePolicy = sendCreatePackagePolicy;
const sendUpdatePackagePolicy = (packagePolicyId, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getUpdatePath(packagePolicyId),
    method: 'put',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(body)
  });
};
exports.sendUpdatePackagePolicy = sendUpdatePackagePolicy;
const sendDeletePackagePolicy = body => {
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getDeletePath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(body)
  });
};
exports.sendDeletePackagePolicy = sendDeletePackagePolicy;
function useGetPackagePoliciesQuery(query, options = {}) {
  return (0, _reactQuery.useQuery)(['packagePolicies'], () => (0, _use_request.sendRequestForRq)({
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    path: _services.packagePolicyRouteService.getListPath(),
    query
  }), options);
}
function useGetPackagePolicies(query) {
  return (0, _use_request.useRequest)({
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    path: _services.packagePolicyRouteService.getListPath(),
    query
  });
}
const sendGetPackagePolicies = query => {
  return (0, _use_request.sendRequest)({
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    path: _services.packagePolicyRouteService.getListPath(),
    query
  });
};
exports.sendGetPackagePolicies = sendGetPackagePolicies;
const useGetOnePackagePolicyQuery = packagePolicyId => {
  return (0, _reactQuery.useQuery)(['packagePolicy', packagePolicyId], () => (0, _use_request.sendRequestForRq)({
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    path: _services.packagePolicyRouteService.getInfoPath(packagePolicyId)
  }));
};
exports.useGetOnePackagePolicyQuery = useGetOnePackagePolicyQuery;
const useGetOnePackagePolicy = packagePolicyId => {
  return (0, _use_request.useRequest)({
    path: _services.packagePolicyRouteService.getInfoPath(packagePolicyId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetOnePackagePolicy = useGetOnePackagePolicy;
const sendGetOnePackagePolicy = packagePolicyId => {
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getInfoPath(packagePolicyId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetOnePackagePolicy = sendGetOnePackagePolicy;
function useUpgradePackagePolicyDryRunQuery(packagePolicyIds, packageVersion, {
  enabled
} = {}) {
  const body = {
    packagePolicyIds
  };
  if (packageVersion) {
    body.packageVersion = packageVersion;
  }
  return (0, _reactQuery.useQuery)(['upgradePackagePolicyDryRun', packagePolicyIds, packageVersion], () => (0, _use_request.sendRequestForRq)({
    path: _services.packagePolicyRouteService.getDryRunPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(body)
  }), {
    enabled
  });
}
function sendUpgradePackagePolicyDryRun(packagePolicyIds, packageVersion) {
  const body = {
    packagePolicyIds
  };
  if (packageVersion) {
    body.packageVersion = packageVersion;
  }
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getDryRunPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(body)
  });
}
function useUpgradePackagePoliciesMutation() {
  return (0, _reactQuery.useMutation)(({
    packagePolicyIds
  }) => (0, _use_request.sendRequestForRq)({
    path: _services.packagePolicyRouteService.getUpgradePath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify({
      packagePolicyIds
    })
  }), {
    retry: false
  });
}
function sendUpgradePackagePolicy(packagePolicyIds) {
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getUpgradePath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify({
      packagePolicyIds
    })
  });
}
function sendGetOrphanedIntegrationPolicies() {
  return (0, _use_request.sendRequest)({
    path: _services.packagePolicyRouteService.getOrphanedIntegrationPoliciesPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
}