"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsGuidedOnboardingActive = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsGuidedOnboardingActive = packageName => {
  const [result, setResult] = (0, _react.useState)(false);
  const {
    guidedOnboarding
  } = (0, _.useStartServices)();
  const isGuidedOnboardingActiveForIntegration = (0, _useObservable.default)(
  // if guided onboarding is not available, return false
  guidedOnboarding !== null && guidedOnboarding !== void 0 && guidedOnboarding.guidedOnboardingApi ? guidedOnboarding.guidedOnboardingApi.isGuidedOnboardingActiveForIntegration$(packageName) : (0, _rxjs.of)(false));
  (0, _react.useEffect)(() => {
    setResult(!!isGuidedOnboardingActiveForIntegration);
  }, [isGuidedOnboardingActiveForIntegration]);
  return result;
};
exports.useIsGuidedOnboardingActive = useIsGuidedOnboardingActive;