"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetServerHostsForPolicy = useFleetServerHostsForPolicy;
var _react = require("react");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return Fleet server hosts urls and proxy for a given agent policy
 */
function useFleetServerHostsForPolicy(agentPolicy) {
  const {
    isLoading,
    isInitialRequest,
    data: enrollmentSettings
  } = (0, _use_request.useGetEnrollmentSettings)({
    agentPolicyId: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id
  });
  return (0, _react.useMemo)(() => {
    var _enrollmentSettings$f;
    return {
      isLoadingInitialRequest: isLoading && isInitialRequest,
      fleetServerHost: (enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : (_enrollmentSettings$f = enrollmentSettings.fleet_server.host) === null || _enrollmentSettings$f === void 0 ? void 0 : _enrollmentSettings$f.host_urls[0]) || '',
      fleetProxy: enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.host_proxy,
      esOutput: enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.es_output,
      esOutputProxy: enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.es_output_proxy,
      downloadSource: enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.download_source,
      downloadSourceProxy: enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.download_source_proxy
    };
  }, [isLoading, isInitialRequest, enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.host, enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.host_proxy, enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.es_output, enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.es_output_proxy, enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.download_source, enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.download_source_proxy]);
}