"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentVersion = void 0;
var _react = require("react");
var _rcompare = _interopRequireDefault(require("semver/functions/rcompare"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _services = require("../../common/services");
var _use_kibana_version = require("./use_kibana_version");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @returns The most compatible agent version available to install or upgrade to.
 */
const useAgentVersion = () => {
  const kibanaVersion = (0, _use_kibana_version.useKibanaVersion)();
  const [agentVersion, setAgentVersion] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const getVersions = async () => {
      try {
        var _res$data;
        const res = await (0, _use_request.sendGetAgentsAvailableVersions)();
        const availableVersions = res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.items;
        let agentVersionToUse;
        availableVersions === null || availableVersions === void 0 ? void 0 : availableVersions.sort(_rcompare.default);
        if (availableVersions && availableVersions.length > 0 && availableVersions.indexOf(kibanaVersion) !== 0) {
          agentVersionToUse = availableVersions.find(version => {
            return (0, _lt.default)(version, kibanaVersion) || (0, _services.differsOnlyInPatch)(version, kibanaVersion);
          }) || availableVersions[0];
        } else {
          agentVersionToUse = kibanaVersion;
        }
        setAgentVersion(agentVersionToUse);
      } catch (err) {
        setAgentVersion(kibanaVersion);
      }
    };
    getVersions();
  }, [kibanaVersion]);
  return agentVersion;
};
exports.useAgentVersion = useAgentVersion;