"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessStepConfirmData = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
var _use_get_agent_incoming_data = require("../agent_enrollment_flyout/use_get_agent_incoming_data");
var _next_steps = require("./next_steps");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentlessStepConfirmData = ({
  agent,
  packagePolicy,
  setConfirmDataStatus,
  policyTemplates
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const [overallState, setOverallState] = (0, _react.useState)('pending');

  // Fetch integration data for the given agent and package policy
  const {
    incomingData,
    hasReachedTimeout
  } = (0, _use_get_agent_incoming_data.usePollingIncomingData)({
    agentIds: [agent.id],
    pkgName: packagePolicy.package.name,
    pkgVersion: packagePolicy.package.version
  });

  // Calculate overall UI state from polling data
  (0, _react.useEffect)(() => {
    if (incomingData.length > 0) {
      setConfirmDataStatus('complete');
      setOverallState('success');
    } else if (hasReachedTimeout) {
      setConfirmDataStatus('danger');
      setOverallState('failure');
    } else {
      setConfirmDataStatus('loading');
      setOverallState('pending');
    }
  }, [incomingData, hasReachedTimeout, setConfirmDataStatus]);
  if (overallState === 'success') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "success",
      title: _i18n.i18n.translate('xpack.fleet.agentlessEnrollmentFlyout.confirmData.successText', {
        defaultMessage: 'Incoming data received from agentless integration'
      }),
      iconType: "check"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_next_steps.NextSteps, {
      packagePolicy: packagePolicy,
      policyTemplates: policyTemplates
    }));
  } else if (overallState === 'failure') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: _i18n.i18n.translate('xpack.fleet.agentlessEnrollmentFlyout.confirmData.failureText', {
        defaultMessage: 'No incoming data received from agentless integration'
      }),
      iconType: "warning"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentlessEnrollmentFlyout.confirmData.failureHelperText",
      defaultMessage: "No integration data received in the past {num} minutes. Check out the {troubleshootingGuideLink} for help.",
      values: {
        num: _use_get_agent_incoming_data.POLLING_TIMEOUT_MS / 1000 / 60,
        troubleshootingGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.troubleshooting,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentlessEnrollmentFlyout.confirmData.pendingHelperText.troubleshootingLinkLabel",
          defaultMessage: "troubleshooting guide"
        }))
      }
    }))));
  }
  return null;
};
exports.AgentlessStepConfirmData = AgentlessStepConfirmData;