"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLanguagesOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _custom_integrations = require("../../../../../../services/custom_integrations");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Renders the content of the component exported from custom language integrations
// This content gets displayed at url /app/integrations/language_clients/pkgkey/overview
// If there is no component exported, redirect to /integrations

const CustomLanguagesOverview = () => {
  const {
    pkgkey
  } = (0, _reactRouterDom.useParams)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  (0, _hooks.useBreadcrumbs)('integration_details_overview', {
    pkgTitle: (0, _lodash.capitalize)(pkgkey)
  });
  const Component = (0, _custom_integrations.getCustomIntegrationsStart)().languageClientsUiComponents[pkgkey];
  return Component ? /*#__PURE__*/_react.default.createElement(Component, null) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: getPath('integrations_all')
  });
};
exports.CustomLanguagesOverview = CustomLanguagesOverview;