"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATE_STORAGE_KEY = exports.STATE_DATASET_FIELD = exports.LOG_LEVEL_FIELD = exports.DEFAULT_LOGS_STATE = exports.DEFAULT_DATE_RANGE = exports.DATASET_FIELD = exports.AGENT_LOG_INDEX_PATTERN = exports.AGENT_ID_FIELD = exports.AGENT_DATASET_PATTERN = exports.AGENT_DATASET_OSQUERYBEAT = exports.AGENT_DATASET_METRICBEAT = exports.AGENT_DATASET_HEARTBEAT = exports.AGENT_DATASET_FILEBEAT = exports.AGENT_DATASET_ENDPOINT_SECURITY = exports.AGENT_DATASET_APM_SERVER = exports.AGENT_DATASET = void 0;
var _constants = require("../../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_LOG_INDEX_PATTERN = exports.AGENT_LOG_INDEX_PATTERN = 'logs-elastic_agent-*,logs-elastic_agent.*-*';
const AGENT_DATASET = exports.AGENT_DATASET = 'elastic_agent';
const AGENT_DATASET_FILEBEAT = exports.AGENT_DATASET_FILEBEAT = 'elastic_agent.filebeat';
const AGENT_DATASET_METRICBEAT = exports.AGENT_DATASET_METRICBEAT = 'elastic_agent.metricbeat';
const AGENT_DATASET_OSQUERYBEAT = exports.AGENT_DATASET_OSQUERYBEAT = 'elastic_agent.osquerybeat';
const AGENT_DATASET_HEARTBEAT = exports.AGENT_DATASET_HEARTBEAT = 'elastic_agent.heartbeat';
const AGENT_DATASET_APM_SERVER = exports.AGENT_DATASET_APM_SERVER = 'elastic_agent.apm_server';
const AGENT_DATASET_ENDPOINT_SECURITY = exports.AGENT_DATASET_ENDPOINT_SECURITY = 'elastic_agent.endpoint_security';
const AGENT_DATASET_PATTERN = exports.AGENT_DATASET_PATTERN = 'elastic_agent.*';
const AGENT_ID_FIELD = exports.AGENT_ID_FIELD = {
  name: 'elastic_agent.id',
  type: 'string'
};
const DATASET_FIELD = exports.DATASET_FIELD = {
  name: _constants.DATASET_VAR_NAME,
  type: 'string',
  aggregatable: true,
  searchable: true
};
const LOG_LEVEL_FIELD = exports.LOG_LEVEL_FIELD = {
  name: 'log.level',
  type: 'string',
  aggregatable: true,
  searchable: true
};
const DEFAULT_DATE_RANGE = exports.DEFAULT_DATE_RANGE = {
  start: 'now-1d',
  end: 'now'
};
const DEFAULT_LOGS_STATE = exports.DEFAULT_LOGS_STATE = {
  start: DEFAULT_DATE_RANGE.start,
  end: DEFAULT_DATE_RANGE.end,
  logLevels: [],
  datasets: [AGENT_DATASET],
  query: ''
};
const STATE_STORAGE_KEY = exports.STATE_STORAGE_KEY = '_q';
const STATE_DATASET_FIELD = exports.STATE_DATASET_FIELD = 'datasets';