"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.displayInputType = displayInputType;
exports.getLogsQueryByInputType = getLogsQueryByInputType;
var _i18n = require("@kbn/i18n");
var _constants = require("../agent_logs/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function displayInputType(inputType) {
  if (inputType === 'logfile') {
    return _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.inputTypeLogText', {
      defaultMessage: 'Logs'
    });
  }
  if (inputType === 'endpoint') {
    return _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.inputTypeEndpointText', {
      defaultMessage: 'Endpoint'
    });
  }
  if (inputType.match(/\/metrics$/)) {
    return _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.inputTypeMetricsText', {
      defaultMessage: 'Metrics'
    });
  }
  return inputType;
}
function getLogsQueryByInputType(inputType) {
  if (inputType === 'logfile') {
    return `(${_constants.STATE_DATASET_FIELD}:!(${_constants.AGENT_DATASET_FILEBEAT}))`;
  }
  if (inputType.match(/\/metrics$/)) {
    return `(${_constants.STATE_DATASET_FIELD}:!(${_constants.AGENT_DATASET_METRICBEAT}))`;
  }
  if (inputType === 'osquery') {
    return `(${_constants.STATE_DATASET_FIELD}:!(${_constants.AGENT_DATASET_OSQUERYBEAT}))`;
  }
  if (inputType.match(/^synthetics\//)) {
    return `(${_constants.STATE_DATASET_FIELD}:!(${_constants.AGENT_DATASET_HEARTBEAT}))`;
  }
  if (inputType === 'apm') {
    return `(${_constants.STATE_DATASET_FIELD}:!(${_constants.AGENT_DATASET_APM_SERVER}))`;
  }
  if (inputType === 'endpoint') {
    return `(${_constants.STATE_DATASET_FIELD}:!(${_constants.AGENT_DATASET_ENDPOINT_SECURITY}))`;
  }
  return '';
}