"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = require("styled-components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerHostSelect = ({
  selectedFleetServerHost,
  setFleetServerHost,
  fleetServerHosts
}) => {
  const theme = (0, _styledComponents.useTheme)();
  const fleetServerHostsOptions = (0, _react.useMemo)(() => [...fleetServerHosts.map(fleetServerHost => {
    return {
      inputDisplay: `${fleetServerHost.name} (${fleetServerHost.host_urls[0]})`,
      value: fleetServerHost.id
    };
  }), {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "plus",
      size: "m",
      color: "primary"
    }),
    inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.addFleetServerHostBtn",
      defaultMessage: "Add new Fleet Server Hosts"
    }),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "relative",
      color: theme.eui.euiColorPrimary
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.addFleetServerHostBtn",
      defaultMessage: "Add new Fleet Server Hosts"
    })),
    'data-test-subj': 'fleetServerSetup.addNewHostBtn',
    value: '@@##ADD_FLEET_SERVER_HOST##@@'
  }], [fleetServerHosts, theme.eui.euiColorPrimary]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    "data-test-subj": "fleetServerSetup.fleetServerHostsSelect",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "relative",
      color: ''
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.fleetServerHostsLabel",
      defaultMessage: "Fleet Server Hosts"
    })),
    onChange: fleetServerHostId => setFleetServerHost(fleetServerHosts.find(fleetServerHost => fleetServerHost.id === fleetServerHostId)),
    valueOfSelected: selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.id,
    options: fleetServerHostsOptions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.FleetServerHostSelect = FleetServerHostSelect;