"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRootIntegrations = getRootIntegrations;
exports.getRootPrivilegedDataStreams = getRootPrivilegedDataStreams;
exports.isRootPrivilegesRequired = isRootPrivilegesRequired;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return true if a package need Elastic Agent to be run as root/administrator
 */
function isRootPrivilegesRequired(packageInfo) {
  var _packageInfo$agent, _packageInfo$agent$pr, _packageInfo$data_str;
  return ((_packageInfo$agent = packageInfo.agent) === null || _packageInfo$agent === void 0 ? void 0 : (_packageInfo$agent$pr = _packageInfo$agent.privileges) === null || _packageInfo$agent$pr === void 0 ? void 0 : _packageInfo$agent$pr.root) || ((_packageInfo$data_str = packageInfo.data_streams) === null || _packageInfo$data_str === void 0 ? void 0 : _packageInfo$data_str.some(d => {
    var _d$agent, _d$agent$privileges;
    return (_d$agent = d.agent) === null || _d$agent === void 0 ? void 0 : (_d$agent$privileges = _d$agent.privileges) === null || _d$agent$privileges === void 0 ? void 0 : _d$agent$privileges.root;
  }));
}
function getRootPrivilegedDataStreams(packageInfo) {
  var _packageInfo$agent2, _packageInfo$agent2$p, _packageInfo$data_str2, _packageInfo$data_str3;
  if ((_packageInfo$agent2 = packageInfo.agent) !== null && _packageInfo$agent2 !== void 0 && (_packageInfo$agent2$p = _packageInfo$agent2.privileges) !== null && _packageInfo$agent2$p !== void 0 && _packageInfo$agent2$p.root) {
    return [];
  }
  return (_packageInfo$data_str2 = (_packageInfo$data_str3 = packageInfo.data_streams) === null || _packageInfo$data_str3 === void 0 ? void 0 : _packageInfo$data_str3.filter(d => {
    var _d$agent2, _d$agent2$privileges;
    return (_d$agent2 = d.agent) === null || _d$agent2 === void 0 ? void 0 : (_d$agent2$privileges = _d$agent2.privileges) === null || _d$agent2$privileges === void 0 ? void 0 : _d$agent2$privileges.root;
  }).map(ds => ({
    name: ds.name,
    title: ds.title
  }))) !== null && _packageInfo$data_str2 !== void 0 ? _packageInfo$data_str2 : [];
}
function getRootIntegrations(packagePolicies) {
  return (0, _lodash.uniqBy)(packagePolicies.map(policy => policy.package).filter(pkg => pkg && pkg.requires_root || false), pkg => pkg.name).map(pkg => ({
    name: pkg.name,
    title: pkg.title
  }));
}