"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TablesAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("events");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var _tables = /*#__PURE__*/new WeakMap();
class TablesAdapter extends _events.EventEmitter {
  constructor(...args) {
    super(...args);
    _classPrivateFieldInitSpec(this, _tables, {});
    (0, _defineProperty2.default)(this, "allowCsvExport", false);
    /** Key of table to set as initial selection */
    (0, _defineProperty2.default)(this, "initialSelectedTable", void 0);
  }
  logDatatable(key, datatable) {
    _classPrivateFieldGet(_tables, this)[key] = datatable;
    this.emit('change', this.tables);
  }
  reset() {
    _classPrivateFieldSet(_tables, this, {});
    this.emit('change', this.tables);
  }
  get tables() {
    return _classPrivateFieldGet(_tables, this);
  }
}
exports.TablesAdapter = TablesAdapter;