"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateMinInterval = calculateMinInterval;
var _public = require("@kbn/data-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _helpers = require("../../common/helpers");
var _layers = require("./layers");
var _visualization = require("./visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function calculateMinInterval(datatableUtilities, {
  args: {
    layers,
    minTimeBarInterval
  }
}) {
  var _datatableUtilities$g;
  const filteredLayers = (0, _layers.getFilteredLayers)(layers);
  if (filteredLayers.length === 0) return;
  const isTimeViz = (0, _helpers.isTimeChart)((0, _visualization.getDataLayers)(filteredLayers));
  const xColumn = (0, _visualization.isDataLayer)(filteredLayers[0]) && filteredLayers[0].xAccessor && (0, _utils.getColumnByAccessor)(filteredLayers[0].xAccessor, filteredLayers[0].table.columns);
  if (!xColumn) return;
  if (minTimeBarInterval) {
    var _search$aggs$parseInt;
    return (_search$aggs$parseInt = _public.search.aggs.parseInterval(minTimeBarInterval)) === null || _search$aggs$parseInt === void 0 ? void 0 : _search$aggs$parseInt.as('milliseconds');
  }
  if (!isTimeViz) {
    const histogramInterval = datatableUtilities.getNumberHistogramInterval(xColumn);
    if (typeof histogramInterval === 'number') {
      return histogramInterval;
    } else {
      return undefined;
    }
  }
  const dateInterval = (_datatableUtilities$g = datatableUtilities.getDateHistogramMeta(xColumn)) === null || _datatableUtilities$g === void 0 ? void 0 : _datatableUtilities$g.interval;
  if (!dateInterval) return;
  const intervalDuration = _public.search.aggs.parseInterval(dateInterval);
  if (!intervalDuration) return;
  return intervalDuration.as('milliseconds');
}