"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPartitionTheme = getPartitionTheme;
var _types = require("../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_SIZE = 1000;
function getPieDonutWaffleCommonTheme(visParams, dimensions, rescaleFactor = 1) {
  const isSplitChart = Boolean(visParams.dimensions.splitColumn || visParams.dimensions.splitRow);
  const preventLinksFromShowing = (visParams.labels.position === _types.LabelPositions.INSIDE || isSplitChart) && visParams.labels.show;
  const usingOuterSizeRatio = dimensions && !isSplitChart ? {
    outerSizeRatio:
    // Cap the ratio to 1 and then rescale
    rescaleFactor * Math.min(MAX_SIZE / Math.min(dimensions === null || dimensions === void 0 ? void 0 : dimensions.width, dimensions === null || dimensions === void 0 ? void 0 : dimensions.height), 1)
  } : {
    outerSizeRatio: undefined
  };
  const partitionTheme = {
    ...(usingOuterSizeRatio !== null && usingOuterSizeRatio !== void 0 ? usingOuterSizeRatio : {})
  };
  if (visParams.labels.show && visParams.labels.position === _types.LabelPositions.DEFAULT && visParams.labels.last_level) {
    var _visParams$labels$tru;
    partitionTheme.linkLabel = {
      maxCount: Number.POSITIVE_INFINITY,
      maximumSection: Number.POSITIVE_INFINITY,
      maxTextLength: (_visParams$labels$tru = visParams.labels.truncate) !== null && _visParams$labels$tru !== void 0 ? _visParams$labels$tru : undefined
    };
  }
  if (preventLinksFromShowing || !visParams.labels.show) {
    // Prevent links from showing
    partitionTheme.linkLabel = {
      maxCount: 0,
      ...(!visParams.labels.show ? {
        maximumSection: Number.POSITIVE_INFINITY
      } : {})
    };
  }
  if (!preventLinksFromShowing && dimensions && !isSplitChart) {
    // shrink up to 20% to give some room for the linked values
    partitionTheme.outerSizeRatio = rescaleFactor;
  }
  return partitionTheme;
}
function getDonutSpecificTheme(visParams, dimensions, rescaleFactor) {
  const partition = getPieDonutWaffleCommonTheme(visParams, dimensions, rescaleFactor);
  return {
    ...partition,
    emptySizeRatio: visParams.emptySizeRatio
  };
}
function getTreemapMosaicCommonTheme(visParams) {
  return !visParams.labels.show ? {
    fillLabel: {
      textColor: 'rgba(0,0,0,0)'
    }
  } : {};
}
function getSpecificTheme(chartType, visParams, dimensions, rescaleFactor) {
  switch (chartType) {
    case _types.ChartTypes.PIE:
      return getPieDonutWaffleCommonTheme(visParams, dimensions, rescaleFactor);
    case _types.ChartTypes.DONUT:
      return getDonutSpecificTheme(visParams, dimensions, rescaleFactor);
    case _types.ChartTypes.TREEMAP:
      return getTreemapMosaicCommonTheme(visParams);
    case _types.ChartTypes.MOSAIC:
      return getTreemapMosaicCommonTheme(visParams);
    case _types.ChartTypes.WAFFLE:
      return getPieDonutWaffleCommonTheme(visParams, dimensions, rescaleFactor);
  }
}
function getPartitionTheme(chartType, visParams, dimensions, rescaleFactor = 1, hasOpenedOnAggBasedEditor) {
  var _visParams$labels$tru2;
  // On small multiples we want the labels to only appear inside
  const isSplitChart = Boolean(visParams.dimensions.splitColumn || visParams.dimensions.splitRow);
  const paddingProps = dimensions && !isSplitChart && hasOpenedOnAggBasedEditor ? {
    chartPaddings: {
      top: (1 - Math.min(1, MAX_SIZE / (dimensions === null || dimensions === void 0 ? void 0 : dimensions.height))) / 2 * (dimensions === null || dimensions === void 0 ? void 0 : dimensions.height),
      bottom: (1 - Math.min(1, MAX_SIZE / (dimensions === null || dimensions === void 0 ? void 0 : dimensions.height))) / 2 * (dimensions === null || dimensions === void 0 ? void 0 : dimensions.height),
      left: (1 - Math.min(1, MAX_SIZE / (dimensions === null || dimensions === void 0 ? void 0 : dimensions.width))) / 2 * (dimensions === null || dimensions === void 0 ? void 0 : dimensions.height),
      right: (1 - Math.min(1, MAX_SIZE / (dimensions === null || dimensions === void 0 ? void 0 : dimensions.width))) / 2 * (dimensions === null || dimensions === void 0 ? void 0 : dimensions.height)
    }
  } : {};
  const specificPartition = getSpecificTheme(chartType, visParams, dimensions, rescaleFactor);
  return {
    partition: {
      outerSizeRatio: 1,
      minFontSize: 10,
      maxFontSize: 16,
      emptySizeRatio: 0,
      sectorLineWidth: 1.5,
      circlePadding: 4,
      ...specificPartition,
      linkLabel: {
        // fontSize: 11,
        maxTextLength: (_visParams$labels$tru2 = visParams.labels.truncate) !== null && _visParams$labels$tru2 !== void 0 ? _visParams$labels$tru2 : undefined,
        maxCount: 5,
        ...(specificPartition === null || specificPartition === void 0 ? void 0 : specificPartition.linkLabel)
      }
    },
    chartMargins: {
      top: 0,
      bottom: 0,
      left: 0,
      right: 0
    },
    ...paddingProps
  };
}