"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionHeatmapPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../common");
var _services = require("./services");
var _expression_renderers = require("./expression_renderers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/** @internal */
class ExpressionHeatmapPlugin {
  setup(core, {
    expressions,
    charts
  }) {
    charts.palettes.getPalettes().then(palettes => {
      (0, _services.setPaletteService)(palettes);
    });
    (0, _services.setUISettings)(core.uiSettings);
    const getStartDeps = (0, _public.createStartServicesGetter)(core.getStartServices);
    expressions.registerFunction(_common.heatmapFunction);
    expressions.registerFunction(_common.heatmapLegendConfig);
    expressions.registerFunction(_common.heatmapGridConfig);
    expressions.registerRenderer((0, _expression_renderers.heatmapRenderer)({
      getStartDeps
    }));
  }
  start(core, {
    data,
    fieldFormats
  }) {
    (0, _services.setFormatService)(fieldFormats);
    (0, _services.setDatatableUtilities)(data.datatableUtilities);
  }
}
exports.ExpressionHeatmapPlugin = ExpressionHeatmapPlugin;