"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseAction = AddToCaseAction;
exports.CaseToastText = CaseToastText;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public2 = require("@kbn/cases-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _use_add_to_case = require("../hooks/use_add_to_case");
var _date_range_picker = require("../components/date_range_picker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddToCaseAction({
  autoOpen,
  lensAttributes,
  owner = _public3.observabilityFeatureId,
  setAutoOpen,
  timeRange
}) {
  var _absoluteFromDate$toI, _absoluteToDate$toISO;
  const kServices = (0, _public.useKibana)().services;
  const userCasesPermissions = kServices.cases.helpers.canUseCases([_public3.observabilityFeatureId]);
  const {
    cases,
    application: {
      getUrlForApp
    }
  } = kServices;
  const getToastText = (0, _react.useCallback)(theCase => (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(CaseToastText, {
    linkUrl: getUrlForApp(_public3.observabilityFeatureId, {
      deepLinkId: _public2.CasesDeepLinkId.cases,
      path: (0, _public2.generateCaseViewPath)({
        detailName: theCase.id
      })
    })
  }), kServices), [getUrlForApp, kServices]);
  const absoluteFromDate = (0, _date_range_picker.parseRelativeDate)(timeRange.from);
  const absoluteToDate = (0, _date_range_picker.parseRelativeDate)(timeRange.to, {
    roundUp: true
  });
  const {
    onCaseClicked,
    isCasesOpen,
    setIsCasesOpen,
    isSaving
  } = (0, _use_add_to_case.useAddToCase)({
    lensAttributes,
    getToastText,
    timeRange: {
      from: (_absoluteFromDate$toI = absoluteFromDate === null || absoluteFromDate === void 0 ? void 0 : absoluteFromDate.toISOString()) !== null && _absoluteFromDate$toI !== void 0 ? _absoluteFromDate$toI : '',
      to: (_absoluteToDate$toISO = absoluteToDate === null || absoluteToDate === void 0 ? void 0 : absoluteToDate.toISOString()) !== null && _absoluteToDate$toISO !== void 0 ? _absoluteToDate$toISO : ''
    },
    appId: _public3.observabilityFeatureId,
    owner
  });
  const getAllCasesSelectorModalProps = {
    permissions: userCasesPermissions,
    onRowClick: onCaseClicked,
    owner: [owner],
    onClose: () => {
      setIsCasesOpen(false);
    }
  };
  (0, _react.useEffect)(() => {
    if (autoOpen) {
      setIsCasesOpen(true);
    }
  }, [autoOpen, setIsCasesOpen]);
  (0, _react.useEffect)(() => {
    if (!isCasesOpen) {
      setAutoOpen === null || setAutoOpen === void 0 ? void 0 : setAutoOpen(false);
    }
  }, [isCasesOpen, setAutoOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof autoOpen === 'undefined' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yAddToCaseActionAddToCaseButton",
    size: "s",
    isLoading: isSaving,
    isDisabled: lensAttributes === null,
    onClick: () => {
      if (lensAttributes) {
        setIsCasesOpen(true);
      }
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.addToCase', {
    defaultMessage: 'Add to case'
  })), isCasesOpen && lensAttributes && cases.ui.getAllCasesSelectorModal(getAllCasesSelectorModalProps));
}
function CaseToastText({
  linkUrl
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11yCaseToastTextViewCaseLink",
    href: linkUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.addToCase.notification.viewCase', {
    defaultMessage: 'View case'
  }))));
}