"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildExistsFilter = buildExistsFilter;
exports.buildPhraseFilter = buildPhraseFilter;
exports.buildPhrasesFilter = buildPhrasesFilter;
exports.createExploratoryViewRoutePath = createExploratoryViewRoutePath;
exports.getQueryFilter = getQueryFilter;
exports.urlFilterToPersistedFilter = urlFilterToPersistedFilter;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _esQuery = require("@kbn/es-query");
var _exploratory_view_url = require("./exploratory_view_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createExploratoryViewRoutePath({
  reportType,
  allSeries
}) {
  const allShortSeries = allSeries.map(series => (0, _exploratory_view_url.convertToShortUrl)(series));
  return `#?reportType=${reportType}&sr=${(0, _exploratory_view_url.encodeUriIfNeeded)(_rison.default.encode(allShortSeries))}`;
}
function buildPhraseFilter(field, value, dataView) {
  const fieldMeta = dataView === null || dataView === void 0 ? void 0 : dataView.fields.find(fieldT => fieldT.name === field);
  if (fieldMeta && dataView) {
    return [(0, _esQuery.buildPhraseFilter)(fieldMeta, value, dataView)];
  }
  return [];
}
function getQueryFilter(field, value, dataView) {
  const fieldMeta = dataView === null || dataView === void 0 ? void 0 : dataView.fields.find(fieldT => fieldT.name === field);
  if (fieldMeta && dataView) {
    return value.map(val => (0, _esQuery.buildQueryFilter)({
      query_string: {
        fields: [field],
        query: `*${val}*`
      }
    }, dataView.id, ''));
  }
  return [];
}
function buildPhrasesFilter(field, value, dataView) {
  const fieldMeta = dataView === null || dataView === void 0 ? void 0 : dataView.fields.find(fieldT => fieldT.name === field);
  if (fieldMeta && dataView) {
    if (value.length === 1) {
      return [(0, _esQuery.buildPhraseFilter)(fieldMeta, value[0], dataView)];
    }
    return [(0, _esQuery.buildPhrasesFilter)(fieldMeta, value, dataView)];
  }
  return [];
}
function buildExistsFilter(field, dataView) {
  const fieldMeta = dataView === null || dataView === void 0 ? void 0 : dataView.fields.find(fieldT => fieldT.name === field);
  if (fieldMeta && dataView) {
    return [(0, _esQuery.buildExistsFilter)(fieldMeta, dataView)];
  }
  return [];
}
function urlFilterToPersistedFilter({
  urlFilters,
  initFilters,
  dataView
}) {
  const parsedFilters = initFilters ? [...initFilters] : [];
  urlFilters.forEach(({
    field,
    values = [],
    notValues = [],
    wildcards = [],
    notWildcards = [] = []
  }) => {
    if (values.length > 0) {
      const filter = buildPhrasesFilter(field, values, dataView);
      parsedFilters.push(...filter);
    }
    if (notValues.length > 0) {
      const filter = buildPhrasesFilter(field, notValues, dataView)[0];
      filter.meta.negate = true;
      parsedFilters.push(filter);
    }
    if (wildcards.length > 0) {
      const filter = getQueryFilter(field, wildcards, dataView);
      parsedFilters.push(...filter);
    }
    if (notWildcards.length > 0) {
      const filter = getQueryFilter(field, notWildcards, dataView)[0];
      filter.meta.negate = true;
      parsedFilters.push(filter);
    }
  });
  return parsedFilters;
}