"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileDeviceDistributionConfig = getMobileDeviceDistributionConfig;
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
var _labels = require("../constants/labels");
var _mobile_fields = require("./mobile_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMobileDeviceDistributionConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.DEVICE_DISTRIBUTION,
    defaultSeriesType: 'bar',
    seriesTypes: ['bar', 'bar_horizontal'],
    xAxisColumn: {
      sourceField: _constants.USE_BREAK_DOWN_COLUMN
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'unique_count'
    }],
    hasOperationType: false,
    filterFields: [...Object.keys(_mobile_fields.MobileFields), _constants.LABEL_FIELDS_FILTER],
    breakdownFields: Object.keys(_mobile_fields.MobileFields),
    baseFilters: [...(0, _utils.buildPhraseFilter)('agent.name', 'iOS/swift', dataView), ...(0, _utils.buildPhraseFilter)('processor.event', 'transaction', dataView)],
    labels: {
      ..._constants.FieldLabels,
      ..._mobile_fields.MobileFields,
      [_elasticsearch_fieldnames.SERVICE_NAME]: _labels.MOBILE_APP
    },
    definitionFields: [_elasticsearch_fieldnames.SERVICE_NAME],
    metricOptions: [{
      field: 'labels.device_id',
      id: 'labels.device_id',
      label: _labels.NUMBER_OF_DEVICES
    }]
  };
}