"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENRICH_MODES = void 0;
exports.checkAggExistence = checkAggExistence;
exports.checkFunctionContent = checkFunctionContent;
exports.validateColumnForGrokDissect = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _i18n = require("@kbn/i18n");
var _helpers = require("../shared/helpers");
var _types = require("./types");
var _errors = require("../validation/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isAggregation(arg) {
  var _getFunctionDefinitio;
  return (0, _helpers.isFunctionItem)(arg) && ((_getFunctionDefinitio = (0, _helpers.getFunctionDefinition)(arg.name)) === null || _getFunctionDefinitio === void 0 ? void 0 : _getFunctionDefinitio.type) === _types.FunctionDefinitionTypes.AGG;
}
function isNotAnAggregation(arg) {
  var _getFunctionDefinitio2;
  return (0, _helpers.isFunctionItem)(arg) && ((_getFunctionDefinitio2 = (0, _helpers.getFunctionDefinition)(arg.name)) === null || _getFunctionDefinitio2 === void 0 ? void 0 : _getFunctionDefinitio2.type) !== _types.FunctionDefinitionTypes.AGG;
}

// now check that:
// * the agg function is at root level
// * or if it's a operators function, then all operands are agg functions or literals
// * or if it's a eval function then all arguments are agg functions or literals
// * or if a named param is used
function checkFunctionContent(arg) {
  // TODO the grouping function check may not
  // hold true for all future cases
  if (isAggregation(arg) || (0, _helpers.isFunctionOperatorParam)(arg)) {
    return true;
  }
  return arg.args.every(subArg => {
    // Differentiate between array and non-array arguments
    if (Array.isArray(subArg)) {
      return subArg.every(item => checkFunctionContent(item));
    }
    return (0, _helpers.isLiteralItem)(subArg) || isAggregation(subArg) || (isNotAnAggregation(subArg) ? checkFunctionContent(subArg) : false);
  });
}
function checkAggExistence(arg) {
  if ((0, _esqlAst.isWhereExpression)(arg)) {
    return checkAggExistence(arg.args[0]);
  }
  if ((0, _esqlAst.isFieldExpression)(arg)) {
    const agg = arg.args[1];
    const firstFunction = _esqlAst.Walker.match(agg, {
      type: 'function'
    });
    if (!firstFunction) {
      return false;
    }
    return checkAggExistence(firstFunction);
  }

  // TODO the grouping function check may not
  // hold true for all future cases
  if (isAggregation(arg) || (0, _helpers.isFunctionOperatorParam)(arg)) {
    return true;
  }
  if (isNotAnAggregation(arg)) {
    return arg.args.filter(_helpers.isFunctionItem).some(checkAggExistence);
  }
  return false;
}
const ENRICH_MODES = exports.ENRICH_MODES = [{
  name: 'any',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqAnyDoc', {
    defaultMessage: 'Enrich takes place on any cluster'
  })
}, {
  name: 'coordinator',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqCoordinatorDoc', {
    defaultMessage: 'Enrich takes place on the coordinating cluster receiving an ES|QL'
  })
}, {
  name: 'remote',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.ccqRemoteDoc', {
    defaultMessage: 'Enrich takes place on the cluster hosting the target index.'
  })
}];
const validateColumnForGrokDissect = (command, {
  fields
}) => {
  const acceptedColumnTypes = ['keyword', 'text'];
  const astCol = command.args[0];
  const columnRef = fields.get(astCol.name);
  if (columnRef && !acceptedColumnTypes.includes(columnRef.type)) {
    return [(0, _errors.getMessageFromId)({
      messageId: 'unsupportedColumnTypeForCommand',
      values: {
        command: command.name.toUpperCase(),
        type: acceptedColumnTypes.join(', '),
        givenType: columnRef.type,
        column: astCol.name
      },
      locations: astCol.location
    })];
  }
  return [];
};
exports.validateColumnForGrokDissect = validateColumnForGrokDissect;