"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _types = require("../../../definitions/types");
var _complete_items = require("../../complete_items");
var _helper = require("../../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest(params) {
  const expressionRoot = params.command.args[0];
  const suggestions = await (0, _helper.suggestForExpression)({
    ...params,
    expressionRoot,
    location: _types.Location.WHERE,
    preferredExpressionType: 'boolean'
  });

  // Is this a complete boolean expression?
  // If so, we can call it done and suggest a pipe
  const expressionType = params.getExpressionType(expressionRoot);
  if (expressionType === 'boolean' && (0, _helper.isExpressionComplete)(expressionType, params.innerText)) {
    suggestions.push(_complete_items.pipeCompleteItem);
  }
  return suggestions;
}