"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLAdHocDataview = getESQLAdHocDataview;
exports.getIndexForESQLQuery = getIndexForESQLQuery;
var _dataViewUtils = require("@kbn/data-view-utils");
var _query_parsing_helpers = require("./query_parsing_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// uses browser sha256 method with fallback if unavailable
async function sha256(str) {
  if (crypto.subtle) {
    const enc = new TextEncoder();
    const hash = await crypto.subtle.digest('SHA-256', enc.encode(str));
    return Array.from(new Uint8Array(hash)).map(v => v.toString(16).padStart(2, '0')).join('');
  } else {
    const {
      sha256: sha256fn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./sha256')));
    return sha256fn(str);
  }
}

// Some applications need to have a dataview to work properly with ES|QL queries
// This is a helper to create one. The id is constructed from the indexpattern.
// As there are no runtime fields or field formatters or default time fields
// the same adhoc dataview can be constructed/used. This comes with great advantages such
// as solving the problem described here https://github.com/elastic/kibana/issues/168131
async function getESQLAdHocDataview(query, dataViewsService) {
  var _dataView$fields, _dataView$fields$getB, _dataView$fields$getB2;
  const timeField = (0, _query_parsing_helpers.getTimeFieldFromESQLQuery)(query);
  const indexPattern = (0, _query_parsing_helpers.getIndexPatternFromESQLQuery)(query);
  const dataView = await dataViewsService.create({
    title: indexPattern,
    type: _dataViewUtils.ESQL_TYPE,
    id: await sha256(`esql-${indexPattern}`)
  });
  dataView.timeFieldName = timeField;

  // If the indexPattern is empty string means that the user used either the ROW, SHOW INFO commands
  // we don't want to add the @timestamp field in this case https://github.com/elastic/kibana/issues/163417
  if (!timeField && indexPattern && (dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : (_dataView$fields$getB = _dataView$fields.getByName) === null || _dataView$fields$getB === void 0 ? void 0 : (_dataView$fields$getB2 = _dataView$fields$getB.call(_dataView$fields, '@timestamp')) === null || _dataView$fields$getB2 === void 0 ? void 0 : _dataView$fields$getB2.type) === 'date') {
    dataView.timeFieldName = '@timestamp';
  }
  return dataView;
}

/**
 * This can be used to get an initial index for a default ES|QL query.
 * Could be used during onboarding when data views to get a better index are not yet available.
 * Can be used in combination with {@link getESQLAdHocDataview} to create a dataview for the index.
 */
async function getIndexForESQLQuery(deps) {
  var _indexName;
  const indices = (await deps.dataViews.getIndices({
    showAllIndices: false,
    pattern: '*',
    isRollupIndex: () => false
  })).filter(index => !index.name.startsWith('.')).map(index => index.name);
  let indexName = indices[0];
  if (indices.length > 0) {
    if (indices.find(index => index.startsWith('logs'))) {
      indexName = 'logs*';
    }
  }
  return (_indexName = indexName) !== null && _indexName !== void 0 ? _indexName : null;
}