"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expr = void 0;
var _query = require("../query");
var _utils = require("../visitor/utils");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generator = (src, {
  withFormatting = true,
  ...rest
} = {}) => {
  const querySrc = 'FROM a | STATS ' + src;
  const query = _query.EsqlQuery.fromSrc(querySrc, {
    withFormatting,
    ...rest
  });
  const where = query.ast.commands[1];
  const expression = (0, _utils.firstItem)(where.args);
  (0, _helpers.makeSynthNode)(expression);
  return expression;
};
const expr = exports.expr = (0, _helpers.createSynthMethod)(generator);