"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateHtmlExtraction = updateHtmlExtraction;
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateHtmlExtraction(client, htmlExtraction, connector) {
  return await client.asCurrentUser.update({
    doc: {
      configuration: {
        ...connector.configuration,
        extract_full_html: {
          label: 'Extract full HTML',
          value: htmlExtraction
        }
      }
    },
    id: connector.id,
    index: _searchConnectors.CONNECTORS_INDEX
  });
}