"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Customize = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _layout = require("../../../components/layout");
var _content_section = require("../../../components/shared/content_section");
var _constants = require("../../../constants");
var _constants2 = require("../constants");
var _settings_logic = require("../settings_logic");
var _branding_section = require("./branding_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Customize = () => {
  const {
    onOrgNameInputChange,
    updateOrgName,
    setStagedIcon,
    setStagedLogo,
    updateOrgLogo,
    updateOrgIcon,
    resetOrgLogo,
    resetOrgIcon
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    dataLoading,
    orgNameInputValue,
    icon,
    stagedIcon,
    logo,
    stagedLogo,
    iconButtonLoading,
    logoButtonLoading
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  const handleSubmit = e => {
    e.preventDefault();
    updateOrgName();
  };
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.SETTINGS],
    pageHeader: {
      pageTitle: _constants.CUSTOMIZE_HEADER_TITLE,
      description: _constants.CUSTOMIZE_HEADER_DESCRIPTION
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.CUSTOMIZE_NAME_LABEL,
    fullWidth: true,
    isInvalid: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: false,
    required: true,
    value: orgNameInputValue,
    "aria-label": _constants.CUSTOMIZE_NAME_LABEL,
    "data-test-subj": "OrgNameInput",
    onChange: e => onOrgNameInputChange(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "SaveOrgNameButton",
    type: "submit"
  }, _constants.CUSTOMIZE_NAME_BUTTON)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_branding_section.BrandingSection, {
    imageType: "logo",
    description: _constants2.LOGO_DESCRIPTION,
    helpText: _constants2.LOGO_HELP_TEXT,
    image: logo,
    stagedImage: stagedLogo,
    buttonLoading: logoButtonLoading,
    stageImage: setStagedLogo,
    saveImage: updateOrgLogo,
    resetImage: resetOrgLogo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_branding_section.BrandingSection, {
    imageType: "icon",
    description: _constants2.ICON_DESCRIPTION,
    helpText: _constants2.ICON_HELP_TEXT,
    image: icon,
    stagedImage: stagedIcon,
    buttonLoading: iconButtonLoading,
    stageImage: setStagedIcon,
    saveImage: updateOrgIcon,
    resetImage: resetOrgIcon
  }));
};
exports.Customize = Customize;