"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateSourcesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _licensing = require("../../../../shared/licensing");
var _constants = require("../../../constants");
var _security_logic = require("../security_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REMOTE_SOURCES_EMPTY_TABLE_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesEmptyTable.description",
  defaultMessage: "Once configured, remote private sources are {enabledStrong}, and users can immediately connect the source from their Personal Dashboard.",
  values: {
    enabledStrong: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.remoteSourcesEmptyTable.enabledStrong', {
      defaultMessage: 'enabled by default'
    }))
  }
});
const STANDARD_SOURCES_EMPTY_TABLE_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.workplaceSearch.security.standardSourcesEmptyTable.description",
  defaultMessage: "Once configured, standard private sources are {notEnabledStrong}, and must be activated before users are allowed to connect the source from their Personal Dashboard.",
  values: {
    notEnabledStrong: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.security.standardSourcesEmptyTable.notEnabledStrong', {
      defaultMessage: 'not enabled by default'
    }))
  }
});
const PrivateSourcesTable = ({
  sourceType,
  sourceSection: {
    isEnabled: sectionEnabled,
    contentSources
  },
  updateSource,
  updateEnabled
}) => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    isEnabled
  } = (0, _kea.useValues)(_security_logic.SecurityLogic);
  const isRemote = sourceType === 'remote';
  const hasSources = contentSources.length > 0;
  const panelDisabled = !isEnabled || !hasPlatinumLicense;
  const sectionDisabled = !sectionEnabled;
  const tableClass = (0, _classnames.default)({
    'euiTable--disabled': sectionDisabled
  });
  const emptyState = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, isRemote ? _constants.REMOTE_SOURCES_EMPTY_TABLE_TITLE : _constants.STANDARD_SOURCES_EMPTY_TABLE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    color: "subdued",
    size: "s"
  }, isRemote ? REMOTE_SOURCES_EMPTY_TABLE_DESCRIPTION : STANDARD_SOURCES_EMPTY_TABLE_DESCRIPTION)));
  const sourcesTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    className: tableClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.SOURCE), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, contentSources.map((source, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, source.name), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: !!source.isEnabled,
    disabled: sectionDisabled,
    onChange: e => updateSource(source.id, e.target.checked),
    showLabel: false,
    label: `${source.name} Toggle`,
    "data-test-subj": `${sourceType}SourceToggle`,
    compressed: true
  }))))))));
  const sectionHeading = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: sectionEnabled,
    onChange: e => updateEnabled(e.target.checked),
    disabled: !isEnabled || !hasPlatinumLicense,
    showLabel: false,
    label: `${sourceType} Sources Toggle`,
    "data-test-subj": `${sourceType}EnabledToggle`,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isRemote ? _constants.REMOTE_SOURCES_TOGGLE_TEXT : _constants.STANDARD_SOURCES_TOGGLE_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, isRemote ? _constants.REMOTE_SOURCES_TABLE_DESCRIPTION : _constants.STANDARD_SOURCES_TABLE_DESCRIPTION), !hasSources && emptyState, hasSources && sourcesTable));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    className: (0, _classnames.default)({
      'euiPanel--disabled': panelDisabled
    })
  }, sectionHeading);
};
exports.PrivateSourcesTable = PrivateSourcesTable;