"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMapping = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _role_mapping = require("../../../shared/role_mapping");
var _constants = require("./constants");
var _group_assignment_selector = require("./group_assignment_selector");
var _role_mappings_logic = require("./role_mappings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const roleOptions = [{
  id: 'admin',
  description: _constants.ADMIN_ROLE_TYPE_DESCRIPTION
}, {
  id: 'user',
  description: _constants.USER_ROLE_TYPE_DESCRIPTION
}];
const RoleMapping = () => {
  const {
    handleSaveMapping,
    handleAttributeValueChange,
    handleAttributeSelectorChange,
    handleRoleChange,
    closeUsersAndRolesFlyout
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    attributes,
    elasticsearchRoles,
    roleType,
    attributeValue,
    attributeName,
    selectedGroups,
    includeInAllGroups,
    roleMapping,
    roleMappingErrors,
    formLoading
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  const isNew = !roleMapping;
  const hasGroupAssignment = selectedGroups.size > 0 || includeInAllGroups;
  const attributeValueInvalid = attributeName !== 'role' && !attributeValue;
  return /*#__PURE__*/_react.default.createElement(_role_mapping.RoleMappingFlyout, {
    disabled: attributeValueInvalid || !hasGroupAssignment,
    formLoading: formLoading,
    isNew: isNew,
    closeUsersAndRolesFlyout: closeUsersAndRolesFlyout,
    handleSaveMapping: handleSaveMapping
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: roleMappingErrors.length > 0,
    error: roleMappingErrors
  }, /*#__PURE__*/_react.default.createElement(_role_mapping.AttributeSelector, {
    attributeName: attributeName,
    attributeValue: attributeValue,
    attributeValueInvalid: attributeValueInvalid,
    attributes: attributes,
    elasticsearchRoles: elasticsearchRoles,
    disabled: !isNew,
    handleAttributeSelectorChange: handleAttributeSelectorChange,
    handleAttributeValueChange: handleAttributeValueChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_role_mapping.RoleSelector, {
    roleOptions: roleOptions,
    roleType: roleType,
    onChange: handleRoleChange,
    label: "Role"
  }), /*#__PURE__*/_react.default.createElement(_group_assignment_selector.GroupAssignmentSelector, null)));
};
exports.RoleMapping = RoleMapping;