"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _groups_logic = require("../groups_logic");
var _table_filter_sources_dropdown = require("./table_filter_sources_dropdown");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_GROUPS_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.filterGroups.placeholder', {
  defaultMessage: 'Filter groups by name...'
});
const TableFilters = () => {
  const {
    setFilterValue
  } = (0, _kea.useActions)(_groups_logic.GroupsLogic);
  const {
    filterValue
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  const handleSearchChange = e => setFilterValue(e.target.value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "user-groups-filters__search-bar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: filterValue,
    onChange: handleSearchChange,
    fullWidth: true,
    placeholder: FILTER_GROUPS_PLACEHOLDER
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "user-groups-filters__filter-sources"
  }, /*#__PURE__*/_react.default.createElement(_table_filter_sources_dropdown.TableFilterSourcesDropdown, null)))));
};
exports.TableFilters = TableFilters;