"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrganizationSources = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _layout = require("../../components/layout");
var _content_section = require("../../components/shared/content_section");
var _sources_table = require("../../components/shared/sources_table");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _constants2 = require("./constants");
var _sources_logic = require("./sources_logic");
var _sources_view = require("./sources_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OrganizationSources = () => {
  const {
    initializeSources,
    setSourceSearchability,
    resetSourcesState
  } = (0, _kea.useActions)(_sources_logic.SourcesLogic);
  (0, _react.useEffect)(() => {
    initializeSources();
    return resetSourcesState;
  }, []);
  const {
    dataLoading,
    contentSources
  } = (0, _kea.useValues)(_sources_logic.SourcesLogic);
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.SOURCES],
    pageViewTelemetry: "organization_sources",
    pageHeader: dataLoading ? undefined : {
      pageTitle: _constants2.ORG_SOURCES_HEADER_TITLE,
      description: _constants2.ORG_SOURCES_HEADER_DESCRIPTION,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
        to: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, true),
        "data-test-subj": "AddSourceButton",
        fill: true
      }, _constants2.ORG_SOURCES_LINK)]
    },
    isLoading: dataLoading,
    isEmptyState: !contentSources.length,
    emptyState: /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, true)
    })
  }, /*#__PURE__*/_react.default.createElement(_sources_view.SourcesView, null, /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, null, /*#__PURE__*/_react.default.createElement(_sources_table.SourcesTable, {
    showDetails: true,
    isOrganization: true,
    onSearchableToggle: setSourceSearchability,
    sources: contentSources
  }))));
};
exports.OrganizationSources = OrganizationSources;