"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchResults = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _constants2 = require("./constants");
var _display_settings_logic = require("./display_settings_logic");
var _example_search_result_group = require("./example_search_result_group");
var _example_standout_result = require("./example_standout_result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchResults = () => {
  const {
    toggleTitleFieldHover,
    toggleSubtitleFieldHover,
    toggleDescriptionFieldHover,
    toggleTypeFieldHover,
    toggleMediaTypeFieldHover,
    toggleCreatedByFieldHover,
    toggleUpdatedByFieldHover,
    setTitleField,
    setSubtitleField,
    setDescriptionField,
    setTypeField,
    setMediaTypeField,
    setCreatedByField,
    setUpdatedByField,
    setUrlField,
    setColorField
  } = (0, _kea.useActions)(_display_settings_logic.DisplaySettingsLogic);
  const {
    searchResultConfig: {
      titleField,
      descriptionField,
      subtitleField,
      typeField,
      mediaTypeField,
      createdByField,
      updatedByField,
      urlField,
      color
    },
    fieldOptions,
    optionalFieldOptions
  } = (0, _kea.useValues)(_display_settings_logic.DisplaySettingsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants2.SEARCH_RESULTS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.TITLE_LABEL,
    onMouseOver: toggleTitleFieldHover,
    onMouseOut: toggleTitleFieldHover,
    onFocus: toggleTitleFieldHover,
    onBlur: toggleTitleFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: fieldOptions,
    required: true,
    name: "titleField",
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "TitleFieldSelect",
    value: titleField || '',
    onChange: e => setTitleField(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.URL_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: fieldOptions,
    required: true,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "UrlFieldSelect",
    value: urlField || '',
    onChange: e => setUrlField(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.COLOR_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: color,
    onChange: setColorField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Subtitle",
    helpText: _constants2.SEARCH_RESULTS_ROW_HELP_TEXT,
    onMouseOver: toggleSubtitleFieldHover,
    onMouseOut: toggleSubtitleFieldHover,
    onFocus: toggleSubtitleFieldHover,
    onBlur: toggleSubtitleFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: optionalFieldOptions,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "SubtitleFieldSelect",
    value: subtitleField || _constants2.LEAVE_UNASSIGNED_FIELD,
    onChange: ({
      target: {
        value
      }
    }) => setSubtitleField(value === _constants2.LEAVE_UNASSIGNED_FIELD ? null : value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.DESCRIPTION_LABEL,
    helpText: _constants2.SEARCH_RESULTS_ROW_HELP_TEXT,
    onMouseOver: toggleDescriptionFieldHover,
    onMouseOut: toggleDescriptionFieldHover,
    onFocus: toggleDescriptionFieldHover,
    onBlur: toggleDescriptionFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: optionalFieldOptions,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "DescriptionFieldSelect",
    value: descriptionField || _constants2.LEAVE_UNASSIGNED_FIELD,
    onChange: ({
      target: {
        value
      }
    }) => setDescriptionField(value === _constants2.LEAVE_UNASSIGNED_FIELD ? null : value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.TYPE_LABEL,
    helpText: _constants2.OPTIONAL_AREA_TEXT,
    onMouseOver: toggleTypeFieldHover,
    onFocus: toggleTypeFieldHover,
    onMouseOut: toggleTypeFieldHover,
    onBlur: toggleTypeFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: optionalFieldOptions,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "TypeFieldSelect",
    value: typeField || _constants2.LEAVE_UNASSIGNED_FIELD,
    onChange: ({
      target: {
        value
      }
    }) => setTypeField(value === _constants2.LEAVE_UNASSIGNED_FIELD ? null : value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.MEDIA_TYPE_LABEL,
    helpText: _constants2.OPTIONAL_AREA_TEXT,
    onMouseOver: toggleMediaTypeFieldHover,
    onFocus: toggleMediaTypeFieldHover,
    onMouseOut: toggleMediaTypeFieldHover,
    onBlur: toggleMediaTypeFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: optionalFieldOptions,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "MediaTypeFieldSelect",
    value: mediaTypeField || _constants2.LEAVE_UNASSIGNED_FIELD,
    onChange: ({
      target: {
        value
      }
    }) => setMediaTypeField(value === _constants2.LEAVE_UNASSIGNED_FIELD ? null : value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.CREATED_BY_LABEL,
    helpText: _constants2.OPTIONAL_AREA_TEXT,
    onMouseOver: toggleCreatedByFieldHover,
    onFocus: toggleCreatedByFieldHover,
    onMouseOut: toggleCreatedByFieldHover,
    onBlur: toggleCreatedByFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: optionalFieldOptions,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "CreatedByFieldSelect",
    value: createdByField || _constants2.LEAVE_UNASSIGNED_FIELD,
    onChange: ({
      target: {
        value
      }
    }) => setCreatedByField(value === _constants2.LEAVE_UNASSIGNED_FIELD ? null : value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants2.UPDATED_BY_LABEL,
    helpText: _constants2.OPTIONAL_AREA_TEXT,
    onMouseOver: toggleUpdatedByFieldHover,
    onFocus: toggleUpdatedByFieldHover,
    onMouseOut: toggleUpdatedByFieldHover,
    onBlur: toggleUpdatedByFieldHover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: optionalFieldOptions,
    className: "field-selector",
    hasNoInitialSelection: true,
    "data-test-subj": "UpdatedByFieldSelect",
    value: updatedByField || _constants2.LEAVE_UNASSIGNED_FIELD,
    onChange: ({
      target: {
        value
      }
    }) => setUpdatedByField(value === _constants2.LEAVE_UNASSIGNED_FIELD ? null : value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants2.PREVIEW_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "section-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _constants2.FEATURED_RESULTS_TITLE)), /*#__PURE__*/_react.default.createElement("p", {
    className: "section-header__description"
  }, _constants2.FEATURED_RESULTS_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_example_standout_result.ExampleStandoutResult, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    className: "section-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _constants2.STANDARD_RESULTS_TITLE)), /*#__PURE__*/_react.default.createElement("p", {
    className: "section-header__description"
  }, _constants2.STANDARD_RESULTS_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_example_search_result_group.ExampleSearchResultGroup, null)))));
};
exports.SearchResults = SearchResults;