"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationChoice = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _app_logic = require("../../../../app_logic");
var _routes = require("../../../../routes");
var _source_data = require("../../source_data");
var _sources_logic = require("../../sources_logic");
var _add_source_header = require("./add_source_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorCard = ({
  title,
  description,
  buttonText,
  to,
  badgeLabel,
  disabledMessage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  isDisabled: !!disabledMessage,
  hasBorder: true,
  title: title,
  description: disabledMessage || description,
  betaBadgeProps: badgeLabel ? {
    label: badgeLabel
  } : undefined,
  footer: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    color: "primary",
    to: to,
    isDisabled: !!disabledMessage
  }, buttonText)
}));
const ConfigurationChoice = ({
  sourceData: {
    name,
    categories = [],
    serviceType
  }
}) => {
  const externalConnectorAvailable = (0, _source_data.hasExternalConnectorOption)(serviceType);
  const customConnectorAvailable = (0, _source_data.hasCustomConnectorOption)(serviceType);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    initializeSources,
    resetSourcesState
  } = (0, _kea.useActions)(_sources_logic.SourcesLogic);
  const {
    externalConfigured
  } = (0, _kea.useValues)(_sources_logic.SourcesLogic);
  (0, _react.useEffect)(() => {
    initializeSources();
    return resetSourcesState;
  }, []);
  const internalTo = `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(serviceType), isOrganization)}/`;
  const externalTo = `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('external', serviceType), isOrganization)}/connector_registration`;
  const customTo = `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('custom', serviceType), isOrganization)}`;
  const internalConnectorProps = {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.internal.title', {
      defaultMessage: 'Connector'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.internal.description', {
      defaultMessage: 'Use this connector to get started quickly without deploying additional infrastructure.'
    }),
    buttonText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.internal.button', {
      defaultMessage: 'Connect'
    }),
    badgeLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.external.recommendedLabel', {
      defaultMessage: 'Recommended'
    }),
    to: internalTo
  };
  const externalConnectorProps = {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.external.title', {
      defaultMessage: 'Connector Package'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.external.description', {
      defaultMessage: 'Deploy this connector package on self-managed infrastructure for advanced use cases.'
    }),
    buttonText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.external.button', {
      defaultMessage: 'Instructions'
    }),
    to: externalTo,
    badgeLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.external.betaLabel', {
      defaultMessage: 'Technical preview'
    })
  };
  const customConnectorProps = {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.custom.title', {
      defaultMessage: 'Custom connector'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.custom.description', {
      defaultMessage: 'Set up a custom connector for more configurability and control.'
    }),
    buttonText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.custom.button', {
      defaultMessage: 'Instructions'
    }),
    to: customTo
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: serviceType,
    categories: categories
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    direction: "row",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(ConnectorCard, (0, _extends2.default)({}, internalConnectorProps, {
    "data-test-subj": "InternalConnectorCard"
  })), externalConnectorAvailable && (externalConfigured ? /*#__PURE__*/_react.default.createElement(ConnectorCard, (0, _extends2.default)({}, externalConnectorProps, {
    buttonText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.configExternalChoice.external.reviewButtonLabel', {
      defaultMessage: 'Review the connector package'
    }),
    to: (0, _routes.getEditPath)('external'),
    "data-test-subj": "ExternalConnectorCard"
  })) : /*#__PURE__*/_react.default.createElement(ConnectorCard, (0, _extends2.default)({}, externalConnectorProps, {
    "data-test-subj": "ExternalConnectorCard"
  }))), customConnectorAvailable && /*#__PURE__*/_react.default.createElement(ConnectorCard, (0, _extends2.default)({}, customConnectorProps, {
    "data-test-subj": "CustomConnectorCard"
  }))));
};
exports.ConfigurationChoice = ConfigurationChoice;