"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BYOSourcePrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _sources_logic = require("../../sources_logic");
var _illustration = _interopRequireDefault(require("./illustration.svg"));
require("./byo_source_prompt.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BYOSourcePrompt = () => {
  const {
    externalConfigured
  } = (0, _kea.useValues)(_sources_logic.SourcesLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    className: "byoSourcePrompt",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "l",
      src: _illustration.default,
      alt: ""
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.byoSourcePrompt.title', {
      defaultMessage: "Don't see what you're looking for?"
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.byoSourcePrompt.description', {
      defaultMessage: 'Build, modify and deploy a connector package for your use case.'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, externalConfigured ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      to: (0, _routes.getEditPath)('external'),
      color: "primary",
      fill: true,
      isDisabled: externalConfigured
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.byoSourcePrompt.reviewButtonLabel', {
      defaultMessage: 'Review your connector package'
    })) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      to: (0, _routes.getSourcesPath)((0, _routes.getAddPath)('external'), true) + '/intro',
      color: "primary",
      fill: true,
      isDisabled: externalConfigured
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.byoSourcePrompt.registerButtonLabel', {
      defaultMessage: 'Register your deployment'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: '' // TODO Update this when we have a doclink
      ,
      color: "primary"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.byoSourcePrompt.learnMoreButtonLabel', {
      defaultMessage: 'Learn more'
    })))))
  });
};
exports.BYOSourcePrompt = BYOSourcePrompt;