"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _enterprise_search_url = require("../../../../shared/enterprise_search_url");
var _telemetry = require("../../../../shared/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductButton = () => {
  const {
    sendWorkplaceSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const buttonProps = {
    fill: true,
    iconType: 'popout',
    'data-test-subj': 'launchButton'
  };
  buttonProps.href = (0, _enterprise_search_url.getWorkplaceSearchUrl)();
  buttonProps.target = '_blank';
  buttonProps.onClick = () => sendWorkplaceSearchTelemetry({
    action: 'clicked',
    metric: 'header_launch_button'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, buttonProps, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.productCta",
    defaultMessage: "Open Workplace Search"
  }));
};
exports.ProductButton = ProductButton;