"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FORM_ID = exports.FIELD_NAME_PLACEHOLDER = exports.FIELD_NAME_CORRECT_NOTE = exports.FIELD_NAME_CORRECTED_NOTE = exports.ADD_FIELD_MODAL_TITLE = exports.ADD_FIELD_MODAL_DESCRIPTION = exports.ADD_FIELD_BUTTON = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FORM_ID = exports.FORM_ID = 'schemaAddFieldForm';
const ADD_FIELD_MODAL_TITLE = exports.ADD_FIELD_MODAL_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.schema.addFieldModal.title', {
  defaultMessage: 'Add a new field'
});
const ADD_FIELD_MODAL_DESCRIPTION = exports.ADD_FIELD_MODAL_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.schema.addFieldModal.description', {
  defaultMessage: 'Once added, a field cannot be removed from your schema.'
});
const ADD_FIELD_BUTTON = exports.ADD_FIELD_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.schema.addFieldModal.addFieldButtonLabel', {
  defaultMessage: 'Add field'
});
const FIELD_NAME_PLACEHOLDER = exports.FIELD_NAME_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.schema.addFieldModal.fieldNamePlaceholder', {
  defaultMessage: 'Enter a field name'
});
const FIELD_NAME_CORRECT_NOTE = exports.FIELD_NAME_CORRECT_NOTE = _i18n.i18n.translate('xpack.enterpriseSearch.schema.addFieldModal.fieldNameNote.correct', {
  defaultMessage: 'Field names can only contain lowercase letters, numbers, and underscores'
});
const FIELD_NAME_CORRECTED_NOTE = correctedName => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.schema.addFieldModal.fieldNameNote.corrected",
  defaultMessage: "The field will be named {correctedName}",
  values: {
    correctedName: /*#__PURE__*/_react.default.createElement("strong", null, correctedName)
  }
});
exports.FIELD_NAME_CORRECTED_NOTE = FIELD_NAME_CORRECTED_NOTE;