"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SETUP_GUIDE_PATH = exports.SETTINGS_PATH = exports.SEARCH_INDICES_PATH = exports.SEARCH_INDEX_TAB_PATH = exports.SEARCH_INDEX_TAB_DETAIL_PATH = exports.SEARCH_INDEX_PATH = exports.SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH = exports.ROOT_PATH = exports.OLD_SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH = exports.NEW_INDEX_SELECT_CONNECTOR_PATH = exports.NEW_INDEX_SELECT_CONNECTOR_NATIVE_PATH = exports.NEW_INDEX_SELECT_CONNECTOR_CLIENTS_PATH = exports.NEW_INDEX_PATH = exports.NEW_ES_INDEX_PATH = exports.NEW_DIRECT_UPLOAD_PATH = exports.NEW_CRAWLER_PATH = exports.NEW_CONNECTOR_PATH = exports.NEW_CONNECTOR_FLOW_PATH = exports.NEW_API_PATH = exports.ML_NOTIFICATIONS_PATH = exports.ML_MANAGE_TRAINED_MODELS_PATH = exports.ERROR_STATE_PATH = exports.DEV_TOOLS_CONSOLE_PATH = exports.CRAWLERS_PATH = exports.CONNECTOR_DETAIL_TAB_PATH = exports.CONNECTOR_DETAIL_PATH = exports.CONNECTORS_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROOT_PATH = exports.ROOT_PATH = '/';
const SETUP_GUIDE_PATH = exports.SETUP_GUIDE_PATH = '/setup_guide';
const ERROR_STATE_PATH = exports.ERROR_STATE_PATH = '/error_state';
const SEARCH_INDICES_PATH = exports.SEARCH_INDICES_PATH = `${ROOT_PATH}search_indices`;
const CONNECTORS_PATH = exports.CONNECTORS_PATH = `${ROOT_PATH}connectors`;
const CRAWLERS_PATH = exports.CRAWLERS_PATH = `${ROOT_PATH}crawlers`;
const SETTINGS_PATH = exports.SETTINGS_PATH = `${ROOT_PATH}settings`;
const NEW_INDEX_PATH = exports.NEW_INDEX_PATH = `${SEARCH_INDICES_PATH}/new_index`;
const NEW_API_PATH = exports.NEW_API_PATH = `${NEW_INDEX_PATH}/api`;
const NEW_ES_INDEX_PATH = exports.NEW_ES_INDEX_PATH = `${NEW_INDEX_PATH}/elasticsearch`;
const NEW_DIRECT_UPLOAD_PATH = exports.NEW_DIRECT_UPLOAD_PATH = `${NEW_INDEX_PATH}/upload`;
const NEW_INDEX_SELECT_CONNECTOR_PATH = exports.NEW_INDEX_SELECT_CONNECTOR_PATH = `${CONNECTORS_PATH}/select_connector`;
const NEW_CONNECTOR_PATH = exports.NEW_CONNECTOR_PATH = `${CONNECTORS_PATH}/new_connector`;
const NEW_CONNECTOR_FLOW_PATH = exports.NEW_CONNECTOR_FLOW_PATH = `${CONNECTORS_PATH}/new_connector_flow`;
const NEW_CRAWLER_PATH = exports.NEW_CRAWLER_PATH = `${CRAWLERS_PATH}/new_crawler`;
const NEW_INDEX_SELECT_CONNECTOR_NATIVE_PATH = exports.NEW_INDEX_SELECT_CONNECTOR_NATIVE_PATH = `${CONNECTORS_PATH}/select_connector?filter=native`;
const NEW_INDEX_SELECT_CONNECTOR_CLIENTS_PATH = exports.NEW_INDEX_SELECT_CONNECTOR_CLIENTS_PATH = `${CONNECTORS_PATH}/select_connector?filter=connector_clients`;
const SEARCH_INDEX_PATH = exports.SEARCH_INDEX_PATH = `${SEARCH_INDICES_PATH}/:indexName`;
const SEARCH_INDEX_TAB_PATH = exports.SEARCH_INDEX_TAB_PATH = `${SEARCH_INDEX_PATH}/:tabId`;
const SEARCH_INDEX_TAB_DETAIL_PATH = exports.SEARCH_INDEX_TAB_DETAIL_PATH = `${SEARCH_INDEX_TAB_PATH}/:detailId`;
const SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH = exports.SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH = `${SEARCH_INDEX_TAB_PATH}/:domainId`;
const OLD_SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH = exports.OLD_SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH = `${SEARCH_INDEX_PATH}/crawler/domains/:domainId`;
const ML_MANAGE_TRAINED_MODELS_PATH = exports.ML_MANAGE_TRAINED_MODELS_PATH = '/app/ml/trained_models';
const ML_NOTIFICATIONS_PATH = exports.ML_NOTIFICATIONS_PATH = '/app/ml/notifications';
const DEV_TOOLS_CONSOLE_PATH = exports.DEV_TOOLS_CONSOLE_PATH = '/app/dev_tools#/console';
const CONNECTOR_DETAIL_PATH = exports.CONNECTOR_DETAIL_PATH = `${CONNECTORS_PATH}/:connectorId`;
const CONNECTOR_DETAIL_TAB_PATH = exports.CONNECTOR_DETAIL_TAB_PATH = `${CONNECTOR_DETAIL_PATH}/:tabId`;