"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicenseBadge = ({
  licenseType,
  modelDetailsPageUrl
}) => {
  const licenseLabel = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelectOption.licenseBadge.label', {
    defaultMessage: 'License: {licenseType}',
    values: {
      licenseType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, modelDetailsPageUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: modelDetailsPageUrl
  }, licenseLabel) : /*#__PURE__*/_react.default.createElement("p", null, licenseLabel));
};
exports.LicenseBadge = LicenseBadge;