"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyAndCustomizePipelinePanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../../../../common/types/api");
var _kibana = require("../../../../../shared/kibana");
var _licensing = require("../../../../../shared/licensing");
var _licensing_callout = require("../../../../../shared/licensing_callout/licensing_callout");
var _create_custom_pipeline_api_logic = require("../../../../api/index/create_custom_pipeline_api_logic");
var _index_view_logic = require("../../index_view_logic");
var _pipelines_logic = require("../pipelines_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CopyAndCustomizePipelinePanel = () => {
  const {
    indexName,
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    status: createStatus
  } = (0, _kea.useValues)(_create_custom_pipeline_api_logic.CreateCustomPipelineApiLogic);
  const {
    hasIndexIngestionPipeline,
    pipelineName
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const {
    makeRequest: createCustomPipeline
  } = (0, _kea.useActions)(_create_custom_pipeline_api_logic.CreateCustomPipelineApiLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  if (hasIndexIngestionPipeline) return null;
  if (isGated) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
      feature: _licensing_callout.LICENSING_FEATURE.PIPELINES
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.copyCustomizeCallout.title', {
      defaultMessage: 'Unlock your custom pipelines'
    }),
    iconType: "lock"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.copyCustomizeCallout.description",
    defaultMessage: "Your index is using our default ingestion pipeline, {defaultPipeline}. Copy that pipeline into an index-specific configuration to unlock the ability to create custom ingestion and inference pipelines.",
    values: {
      defaultPipeline: /*#__PURE__*/_react.default.createElement("strong", null, pipelineName)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-copyAndCustomize`,
    isLoading: createStatus === _api.Status.LOADING,
    iconType: "lockOpen",
    onClick: () => createCustomPipeline({
      indexName
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.copyButtonLabel', {
    defaultMessage: 'Copy and customize'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.CopyAndCustomizePipelinePanel = CopyAndCustomizePipelinePanel;