"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDomainFormErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_domain_logic = require("./add_domain_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDomainFormErrors = () => {
  const {
    errors
  } = (0, _kea.useValues)(_add_domain_logic.AddDomainLogic);
  if (errors.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.addDomainForm.errorsTitle', {
        defaultMessage: 'Something went wrong. Please address the errors and try again.'
      })
    }, errors.map((message, index) => /*#__PURE__*/_react.default.createElement("p", {
      key: index
    }, message)));
  }
  return null;
};
exports.AddDomainFormErrors = AddDomainFormErrors;