"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtractionRules = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../shared/constants");
var _doc_links = require("../../../../../../shared/doc_links");
var _page_introduction = require("../../../../../../shared/page_introduction/page_introduction");
var _edit_extraction_rule = require("./edit_extraction_rule");
var _extraction_rules_logic = require("./extraction_rules_logic");
var _extraction_rules_table = require("./extraction_rules_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExtractionRules = () => {
  var _extractionRuleToDele;
  const {
    cancelEditExtractionRule,
    deleteExtractionRule,
    editNewExtractionRule,
    hideDeleteModal,
    saveExtractionRule
  } = (0, _kea.useActions)(_extraction_rules_logic.ExtractionRulesLogic);
  const {
    deleteModalVisible,
    editingExtractionRule,
    extractionRules,
    extractionRuleToDelete,
    extractionRuleToEdit,
    extractionRuleToEditIsNew
  } = (0, _kea.useValues)(_extraction_rules_logic.ExtractionRulesLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    maxWidth: true,
    buttonColor: "danger",
    onCancel: hideDeleteModal,
    onConfirm: deleteExtractionRule,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.deleteModal.confirmLabel', {
      defaultMessage: 'Delete rule'
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.deleteModal.title', {
      defaultMessage: 'Are you sure you want to delete this extraction rule?'
    }),
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.deleteModal.description', {
    defaultMessage: 'Removing this rule will also delete {fields, plural, one {one field rule} other {# field rules}}. This action cannot be undone.',
    values: {
      fields: (_extractionRuleToDele = extractionRuleToDelete === null || extractionRuleToDelete === void 0 ? void 0 : extractionRuleToDelete.rules.length) !== null && _extractionRuleToDele !== void 0 ? _extractionRuleToDele : 0
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_page_introduction.PageIntroduction, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.title', {
      defaultMessage: 'Extraction rules'
    }))),
    description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.crawler.extractionRules.description",
      defaultMessage: "Create a content extraction rule to change where the documents get their data during a sync."
    })),
    links: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.crawlerExtractionRules,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRules.learnMoreLink', {
      defaultMessage: 'Learn more about content extraction rules.'
    })),
    actions: extractionRules.length === 0 ? [] : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-addContentExtractionRule",
      iconType: "plusInCircle",
      onClick: editNewExtractionRule
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRulesTable.addRuleLabel', {
      defaultMessage: 'Add extraction rule'
    }))]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), editingExtractionRule ? /*#__PURE__*/_react.default.createElement(_edit_extraction_rule.EditExtractionRule, {
    cancelEditing: cancelEditExtractionRule,
    extractionRule: extractionRuleToEdit,
    isNewRule: extractionRuleToEditIsNew,
    saveRule: saveExtractionRule
  }) : extractionRules.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRulesTable.emptyMessageTitle', {
      defaultMessage: 'There are no content extraction rules'
    })),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRulesTable.emptyMessageDescription', {
      defaultMessage: 'Create a content extraction rule to change where document fields get their data during a sync.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-addContentExtractionRule",
      iconType: "plusInCircle",
      onClick: editNewExtractionRule
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.extractionRulesTable.emptyMessageAddRuleLabel', {
      defaultMessage: 'Add content extraction rule'
    }))
  }) : /*#__PURE__*/_react.default.createElement(_extraction_rules_table.ExtractionRulesTable, null));
};
exports.ExtractionRules = ExtractionRules;