"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationPanelActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../shared/constants");
var _crawler_domain_detail_logic = require("../crawler_domain_detail_logic");
var _authentication_panel_logic = require("./authentication_panel_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationPanelActions = () => {
  var _domain$auth;
  const {
    domain
  } = (0, _kea.useValues)(_crawler_domain_detail_logic.CrawlerDomainDetailLogic);
  const currentAuth = (_domain$auth = domain === null || domain === void 0 ? void 0 : domain.auth) !== null && _domain$auth !== void 0 ? _domain$auth : null;
  const {
    disableEditing,
    enableEditing,
    saveCredentials,
    setIsModalVisible
  } = (0, _kea.useActions)(_authentication_panel_logic.AuthenticationPanelLogic);
  const {
    isEditing
  } = (0, _kea.useValues)(_authentication_panel_logic.AuthenticationPanelLogic);
  return isEditing ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-authentication-save",
    iconType: "checkInCircleFilled",
    size: "s",
    color: "primary",
    onClick: () => saveCredentials()
  }, _constants.SAVE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-authentication-cancel",
    iconType: "cross",
    size: "s",
    color: "danger",
    onClick: () => disableEditing()
  }, _constants.CANCEL_BUTTON_LABEL))) : currentAuth === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-authentication-addCredentials",
    color: "success",
    iconType: "plusInCircle",
    size: "s",
    onClick: () => enableEditing(currentAuth)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.resetToDefaultsButtonLabel', {
    defaultMessage: 'Add credentials'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-authentication-deleteCredentials",
    color: "primary",
    size: "s",
    onClick: () => {
      setIsModalVisible(true);
    }
  }, _constants.DELETE_BUTTON_LABEL);
};
exports.AuthenticationPanelActions = AuthenticationPanelActions;