"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescriptionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _api = require("../../../../../../../common/types/api");
var _constants = require("../../../../../shared/constants");
var _update_connector_name_and_description_api_logic = require("../../../../api/connector/update_connector_name_and_description_api_logic");
var _connector_name_and_description_form_content = require("./connector_name_and_description_form_content");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorNameAndDescriptionForm = () => {
  const {
    status
  } = (0, _kea.useValues)(_update_connector_name_and_description_api_logic.ConnectorNameAndDescriptionApiLogic);
  const {
    saveNameAndDescription,
    setIsEditing
  } = (0, _kea.useActions)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      saveNameAndDescription();
    },
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_connector_name_and_description_form_content.ConnectorNameAndDescriptionFormContent, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-configuration-nameAndDescription-save",
    type: "submit",
    isLoading: status === _api.Status.LOADING
  }, _constants.SAVE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-configuration-nameAndDescription-cancel",
    isDisabled: status === _api.Status.LOADING,
    onClick: () => {
      setIsEditing(false);
    }
  }, _constants.CANCEL_BUTTON_LABEL)))));
};
exports.ConnectorNameAndDescriptionForm = ConnectorNameAndDescriptionForm;