"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSearchIndexPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../shared/kibana");
var _query_params = require("../../../shared/query_params");
var _connectors = require("../connectors/connectors");
var _page_template = require("../layout/page_template");
var _search_indices = require("../search_indices");
var _method_api = require("./method_api/method_api");
var _method_connector = require("./method_connector/method_connector");
var _method_crawler = require("./method_crawler/method_crawler");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTitle(method, serviceType, connectorTypes) {
  switch (method) {
    case _constants.INGESTION_METHOD_IDS.API:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.apiTitle', {
        defaultMessage: 'New search index'
      });
    case _constants.INGESTION_METHOD_IDS.CONNECTOR:
      {
        const connector = Boolean(serviceType) && connectorTypes.find(item => item.serviceType === serviceType);
        return connector ? _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.connectorTitleWithServiceType', {
          defaultMessage: 'New {name} connector',
          values: {
            name: connector.name
          }
        }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.connectorTitle', {
          defaultMessage: 'New connector search index'
        });
      }
    case _constants.INGESTION_METHOD_IDS.CRAWLER:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.crawlerTitle', {
        defaultMessage: 'Web crawler search index'
      });
    default:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.genericTitle', {
        defaultMessage: 'New search index'
      });
  }
}
function getDescription(method) {
  switch (method) {
    case _constants.INGESTION_METHOD_IDS.API:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.apiDescription', {
        defaultMessage: 'Use the API to programatically add documents to an Elasticsearch index. Start by creating your index.'
      });
    case _constants.INGESTION_METHOD_IDS.CONNECTOR:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.connectorDescriptionWithServiceType', {
          defaultMessage: 'Use a connector to sync, extract, transform and index data from your data source. Connectors are Elastic integrations that write directly to Elasticsearch indices.'
        });
      }
    case _constants.INGESTION_METHOD_IDS.CRAWLER:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.crawlerDescription', {
        defaultMessage: 'Use the web crawler to programmatically discover, extract, and index searchable content from websites and knowledge bases.'
      });
    default:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.defaultDescription', {
        defaultMessage: 'A search index stores your data.'
      });
  }
}
const parseIsNativeParam = queryString => {
  const parsedStr = Array.isArray(queryString) ? queryString[0] : queryString;
  if (parsedStr === _constants.CONNECTOR_NATIVE_TYPE) return true;
  if (parsedStr === _constants.CONNECTOR_CLIENTS_TYPE) return false;
  return undefined;
};
const getBreadcrumb = (method, serviceType, connectorTypes) => {
  switch (method) {
    case _constants.INGESTION_METHOD_IDS.CONNECTOR:
      const connector = Boolean(serviceType) && connectorTypes.find(item => item.serviceType === serviceType);
      const thisConnectorBreadcrumb = connector ? _i18n.i18n.translate('xpack.enterpriseSearch.content.new_connector_with_service_type.breadcrumbs', {
        defaultMessage: `New {name} connector`,
        values: {
          name: connector.name
        }
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.new_connector.breadcrumbs', {
        defaultMessage: `New connector`
      });
      return [..._connectors.connectorsBreadcrumbs, thisConnectorBreadcrumb];
    case _constants.INGESTION_METHOD_IDS.CRAWLER:
      return [..._connectors.crawlersBreadcrumbs, _i18n.i18n.translate('xpack.enterpriseSearch.content.new_web_crawler.breadcrumbs', {
        defaultMessage: 'New web crawler'
      })];
    default:
      return [..._search_indices.baseBreadcrumbs, _i18n.i18n.translate('xpack.enterpriseSearch.content.new_index.breadcrumbs', {
        defaultMessage: 'New search index'
      })];
  }
};
const getConnectorModeBadge = isNative => {
  if (isNative) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconSide: "right"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.getConnectorTypeBadge.nativeBadgeLabel",
      defaultMessage: "Elastic managed connector"
    }));
  }
  if (!isNative) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconSide: "right"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.getConnectorTypeBadge.connectorClientBadgeLabel', {
      defaultMessage: 'Self-managed'
    }));
  }
  return undefined;
};
const NewSearchIndexPage = ({
  type
}) => {
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    service_type: inputServiceType,
    connector_type: inputConnectorType
  } = (0, _query_params.parseQueryParams)(search);
  const serviceType = Array.isArray(inputServiceType) ? inputServiceType[0] : inputServiceType || '';
  const isNative = parseIsNativeParam(inputConnectorType);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: getBreadcrumb(type, serviceType, connectorTypes),
    pageViewTelemetry: "New Index",
    isLoading: false,
    pageHeader: {
      description: getDescription(type),
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: (0, _utils.getIngestionMethodIconType)(type),
        size: "xxl"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, getTitle(type, serviceType, connectorTypes)), type === _constants.INGESTION_METHOD_IDS.CONNECTOR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, getConnectorModeBadge(isNative)))
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, type === _constants.INGESTION_METHOD_IDS.CRAWLER && /*#__PURE__*/_react.default.createElement(_method_crawler.MethodCrawler, null), type === _constants.INGESTION_METHOD_IDS.API && /*#__PURE__*/_react.default.createElement(_method_api.MethodApi, null), type === _constants.INGESTION_METHOD_IDS.CONNECTOR && /*#__PURE__*/_react.default.createElement(_method_connector.MethodConnector, {
    serviceType: serviceType,
    isNative: isNative
  })));
};
exports.NewSearchIndexPage = NewSearchIndexPage;