"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MethodCrawlerLogic = void 0;
var _kea = require("kea");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _create_crawler_index_api_logic = require("../../../api/crawler/create_crawler_index_api_logic");
var _routes = require("../../../routes");
var _search_index = require("../../search_index/search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MethodCrawlerLogic = exports.MethodCrawlerLogic = (0, _kea.kea)({
  connect: {
    actions: [_create_crawler_index_api_logic.CreateCrawlerIndexApiLogic, ['apiError', 'apiSuccess']]
  },
  listeners: {
    apiSuccess: ({
      created
    }) => {
      _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName: created,
        tabId: _search_index.SearchIndexTabId.DOMAIN_MANAGEMENT
      }));
    }
  },
  path: ['enterprise_search', 'content', 'method_crawler']
});