"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fetch_sync_jobs_stats_api_logic = require("../../api/stats/fetch_sync_jobs_stats_api_logic");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorStats = ({
  isCrawler
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tooltipAncherProps = {
    css: (0, _react2.css)`
      margin: ${euiTheme.size.xs};
    `
  };
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const {
    data
  } = (0, _kea.useValues)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const connectorCount = ((data === null || data === void 0 ? void 0 : data.connected) || 0) + ((data === null || data === void 0 ? void 0 : data.incomplete) || 0);
  const hasMultipleConnectors = connectorCount > 1;
  const connectedCount = (data === null || data === void 0 ? void 0 : data.connected) || 0;
  const incompleteCount = (data === null || data === void 0 ? void 0 : data.incomplete) || 0;
  const inProgressCount = (data === null || data === void 0 ? void 0 : data.in_progress) || 0;
  const idleCount = (data === null || data === void 0 ? void 0 : data.idle) || 0;
  const orphanedCount = (data === null || data === void 0 ? void 0 : data.orphaned_jobs) || 0;
  const errorCount = (data === null || data === void 0 ? void 0 : data.errors) || 0;
  (0, _react.useEffect)(() => {
    makeRequest({
      isCrawler
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.connectorSummaryLabel', {
    defaultMessage: 'Connector summary'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.crawlerSummaryLabel', {
    defaultMessage: 'Web crawler summary'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, !isCrawler ? hasMultipleConnectors ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.multipleConnectorsText', {
    defaultMessage: '{count} connectors',
    values: {
      count: connectorCount
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.singleConnectorText', {
    defaultMessage: '{count} connector',
    values: {
      count: connectorCount
    }
  }) : hasMultipleConnectors ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.multipleCrawlersText', {
    defaultMessage: '{count} web crawlers',
    values: {
      count: connectorCount
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.singleCrawlerText', {
    defaultMessage: '{count} web crawler',
    values: {
      count: connectorCount
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getConnectedConnectorsTooltipContent)(connectedCount, isCrawler)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success",
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getConnectedBadgeAriaLabel)(connectedCount)
  }, (0, _utils.getConnectedConnectorsBadgeLabel)(connectedCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getIncompleteConnectorsTooltip)(incompleteCount, isCrawler)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getIncompleteConnectorBadgeAriaLabel)(incompleteCount)
  }, (0, _utils.getIncompleteConnectorsBadgeLabel)(incompleteCount)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.syncsStatusLabel', {
    defaultMessage: 'Syncs status'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, (0, _utils.getRunningJobsLabel)(inProgressCount, isCrawler))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getRunningJobsTooltip)(inProgressCount, isCrawler)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getRunningJobsBadgeAriaLabel)(inProgressCount, isCrawler)
  }, (0, _utils.getRunningJobsBadgeLabel)(inProgressCount, isCrawler))), !isCrawler && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getIdleJobsTooltip)(idleCount)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getIdleJobsLabel)(idleCount)
  }, (0, _utils.getIdleJobsLabel)(idleCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getOrphanedJobsTooltip)(orphanedCount, isCrawler)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getOrphanedJobsLabel)(orphanedCount, isCrawler)
  }, (0, _utils.getOrphanedJobsLabel)(orphanedCount, isCrawler))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getSyncJobErrorsTooltip)(errorCount, isCrawler)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getSyncJobErrorsLabel)(errorCount, isCrawler),
    color: errorCount > 0 ? 'danger' : 'default'
  }, (0, _utils.getSyncJobErrorsLabel)(errorCount, isCrawler)))))));
};
exports.ConnectorStats = ConnectorStats;