"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateConnectorNames = exports.GenerateConnectorNamesApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConnectorNames = async ({
  connectorType,
  connectorName
} = {
  connectorType: 'custom'
}) => {
  if (connectorType === '') {
    connectorType = 'custom';
  }
  const route = `/internal/enterprise_search/connectors/generate_connector_name`;
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      connectorName,
      connectorType
    })
  });
};
exports.generateConnectorNames = generateConnectorNames;
const GenerateConnectorNamesApiLogic = exports.GenerateConnectorNamesApiLogic = (0, _create_api_logic.createApiLogic)(['generate_connector_names_api_logic'], generateConnectorNames);