"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynonymModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _flash_messages = require("../../../../shared/flash_messages");
var _multi_input_rows = require("../../multi_input_rows");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynonymModal = () => {
  const {
    isModalOpen,
    modalLoading,
    activeSynonymSet
  } = (0, _kea.useValues)(_.SynonymsLogic);
  const {
    closeModal,
    createSynonymSet,
    updateSynonymSet,
    deleteSynonymSet
  } = (0, _kea.useActions)(_.SynonymsLogic);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const modalTitle = activeSynonymSet ? _constants2.SYNONYM_UPDATE_TITLE : _constants2.SYNONYM_CREATE_TITLE;
  const id = (activeSynonymSet === null || activeSynonymSet === void 0 ? void 0 : activeSynonymSet.id) || 'createNewSynonymSet';
  const synonyms = (activeSynonymSet === null || activeSynonymSet === void 0 ? void 0 : activeSynonymSet.synonyms) || ['', ''];
  const onSubmit = activeSynonymSet ? updatedSynonyms => updateSynonymSet({
    id,
    synonyms: updatedSynonyms
  }) : newSynonyms => createSynonymSet(newSynonyms);
  return isModalOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, modalTitle)), /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_multi_input_rows.MultiInputRows, {
    id: id,
    initialValues: synonyms,
    inputPlaceholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.synonymInputPlaceholder', {
      defaultMessage: 'Enter a synonym'
    }),
    onSubmit: onSubmit,
    showSubmitButton: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, activeSynonymSet && /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconType: "trash",
    onClick: () => {
      if (window.confirm(_constants2.DELETE_CONFIRMATION)) deleteSynonymSet(id);
    },
    "data-test-subj": "deleteSynonymSetButton"
  }, _constants.DELETE_BUTTON_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchSynonymModalButton",
    onClick: closeModal
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    form: id,
    fill: true,
    isLoading: modalLoading,
    "data-test-subj": "submitSynonymSetButton"
  }, _constants.SAVE_BUTTON_LABEL))))) : null;
};
exports.SynonymModal = SynonymModal;