"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generatePreviewUrl = void 0;
var _queryString = _interopRequireDefault(require("query-string"));
var _enterprise_search_url = require("../../../shared/enterprise_search_url");
var _engine = require("../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generatePreviewUrl = query => {
  const {
    engineName
  } = _engine.EngineLogic.values;
  return _queryString.default.stringifyUrl({
    query,
    url: (0, _enterprise_search_url.getAppSearchUrl)(`/engines/${engineName}/search_experience/preview`)
  }, {
    arrayFormat: 'bracket',
    skipEmptyString: true
  });
};
exports.generatePreviewUrl = generatePreviewUrl;