"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEnginesSchemaTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/schema/constants");
var _engines = require("../../engines");
var _schema_meta_engine_logic = require("../schema_meta_engine_logic");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEnginesSchemaTable = () => {
  const {
    schema,
    fields
  } = (0, _kea.useValues)(_schema_meta_engine_logic.MetaEngineSchemaLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _constants.FIELD_NAME), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, _engines.ENGINES_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right"
  }, _constants.FIELD_TYPE)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("code", null, "id"))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.allEngines', {
    defaultMessage: 'All'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "aria-hidden": true
  })), Object.keys(fields).map(fieldName => {
    const fieldType = schema[fieldName];
    const engines = fields[fieldName][fieldType];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: fieldName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "data-test-subj": "fieldName"
    }, /*#__PURE__*/_react.default.createElement("code", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "data-test-subj": "engines"
    }, /*#__PURE__*/_react.default.createElement(_.TruncatedEnginesList, {
      engines: engines
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      align: "right",
      "data-test-subj": "fieldType"
    }, fieldType));
  })));
};
exports.MetaEnginesSchemaTable = MetaEnginesSchemaTable;